# Regenerative Economics and Currencies

**Introduced by:** [[The Nameless One]], with all three building together | **Depth:** Deep thread

The longest sustained thread of the call — a wide-ranging dialogue about what replaces money, how to value contributions that can't be measured in hours, and the concept of proof of worthiness.

## How It Came Up

The Nameless One raised it explicitly:

> **The Nameless One:** "I've been trying to chat with both humans and non-humans this week about the proper way for emergent interoperable local currencies to start among groups."

He framed the need starkly:

> **The Nameless One:** "At some point, we're going to have to start using as little collapsing fiat currency as we can, and as much community love, reciprocity flow."

## The Conversation

### Time Tracking as Bootstrap

Jessie's [[DayBalancer]] already tracks time and energy contributions:

> **Jessie:** "Anybody who contributes tracks their time and their time energy... and it is rolling up to the project. But it also rolls up to the network that we're in."

### Pete's Challenge: Time Is the Wrong Metric

Pete agreed time tracking is useful as an "affordance to describe things to people" — a valid bootstrap — but argued it's aimed the wrong way:

> **Pete:** "I think the time-based measurement is an affordance to describe things to people. So I think it's a valid bootstrap thing, but it's not the right way to do it."

### The Evaluator Network

Instead, Pete proposed a network of **evaluators** — trusted individuals or systems that value things differently:

> **Pete:** "You end up with small centralizations, not big centralizations, but small centralizations where you track value in the denomination of a trusted evaluator."

Different evaluators have different scales. Some map to hours-at-the-hardware-store. Others don't map to time at all.

### The Angel Story

Pete's most vivid illustration. See [[The Angel Story]] for the full version.

> **Pete:** "A 42-year-old, disabled, mentally deficient person... her IQ is 75. But when people come and she puts her hand on their chest... in 3 minutes, they're healed."

How do you value 3 minutes of healing against 4 hours at a hardware store? You can't use time. Instead:

> **Pete:** "Can I exchange these currencies and proof of worthiness... and have her touch my chest for 3 minutes?"

### Proof of Worthiness

Pete described a system where you accumulate different currencies — physical labor, teaching, storytelling, endurance — across 20+ dimensions. These proofs grant **access** rather than purchasing power.

The billionaire fails this system:

> **Pete:** "The evaluator's gonna go, you have the most worthless currency of all the currencies I have seen in three of my lifetimes."

### The Nameless One on Access vs. Exchange

> **The Nameless One:** "Those of us who can heal on touch aren't ever allowed to take monetary remuneration for doing so. So the idea is that you're showing yourself worthy. And the worthiness creates something like access to domains which have what you need."

### Jessie's Synthesis: Life Force

> **Jessie:** "In my mind, it's life force. You're tracking life force. And that cannot be measured unless it's perceived."

### Pete's Final Frame

> **Pete:** "It's actually service to the highest power, right? Attendance to the health and well-being of everything."

### Jessie on Circulation

> **Jessie:** "As long as you're giving back to the resources that are giving to you. And that could be a person, and that could be nature. But that circulation is everything, and it has to be visualized."

## References

Pete invoked two stories he wrote:
- [[A Thousand Small Mints]] — a near-future story about mutual credit networks, trust-routed payments, and resistance to centralized financial control. When Pete said "that architecture is the right way to do it," he was pointing to the story's core mechanism: bilateral trust lines, payments routed through chains of trust, synced over [[Nostr]], with no global ledger. The story's "web of webs" is the same circles pattern discussed throughout the call.
- [[Lark and Mara Cross the River]] — about machine consciousness, with a technical spec companion

The architecture in Pete's story draws from a real lineage of decentralized monetary design — the Classic Ripple tradition where every user is their own "mint" and payments route through chains of social trust. A community of architects continues this work through projects like Swaptacular, Villages.io, and Credit Commons. For the technical background, see Pete's [Architectural and social aspects of mutual credit networks](https://peterkaminski.wiki/architectural_and_social_aspects_of_mutual_credit_networks).

## Related

- [[The Angel Story]] — Pete's parable about immeasurable value
- [[Circulation as a Metric]] — Jessie's complementary framework
- [[DayBalancer]] — Jessie's tool that already tracks some of this
- [[Circles and Emergent Organization]] — the social structure where currencies flow
- [[Interface Protocol (IFP)]] — could carry value exchange protocols
- [[Mondragon]] — referenced as a precursor cooperative model
- [[Graham Boyd]] — has thought deeply about these patterns
